/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.HitResult;

public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    private List<ObservationTask> observationTasks = null;
    private ObservationTask currentlyObserving = null;
    private long currentlyObservingTicks = 0L;

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::registerItemColors);
        SidebarButtonCreatedEvent.EVENT.register(this::onSidebarButtonCreated);
        ClearFileCacheEvent.EVENT.register(this::onFileCacheClear);
        ClientTickEvent.CLIENT_PRE.register(this::onKeyEvent);
        CustomClickEvent.EVENT.register(this::onCustomClick);
        ClientTickEvent.CLIENT_PRE.register(this::onClientTick);
        ClientGuiEvent.RENDER_HUD.register(this::onScreenRender);
    }

    private void registerItemColors(Minecraft minecraft) {
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> {
            LootCrate crate = LootCrateItem.getCrate(stack);
            return crate == null ? -1 : 0xFF000000 | crate.color.rgb();
        }, (ItemLike[])new ItemLike[]{(ItemLike)FTBQuestsItems.LOOTCRATE.get()});
    }

    private void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists()) {
                    if (ClientQuestFile.INSTANCE.disableGui && !ClientQuestFile.INSTANCE.canEdit()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.self.isLocked()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.self.hasUnclaimedRewards(Minecraft.m_91087_().f_91074_.m_142081_(), ClientQuestFile.INSTANCE)) {
                        return "[!]";
                    }
                }
                return "";
            });
        }
    }

    private void onFileCacheClear(QuestFile file) {
        this.observationTasks = null;
    }

    private void onKeyEvent(Minecraft mc) {
        if (FTBQuestsClient.KEY_QUESTS.m_90859_()) {
            ClientQuestFile.INSTANCE.openQuestGui();
        }
    }

    private EventResult onCustomClick(CustomClickEvent event) {
        if (event.id().m_135827_().equals("ftbquests") && "open_gui".equals(event.id().m_135815_())) {
            if (!ClientQuestFile.exists()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)new TextComponent("Error?! Server doesn't have FTB Quests!"), null));
            } else {
                ClientQuestFile.INSTANCE.openQuestGui();
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private void onClientTick(Minecraft mc) {
        if (mc.f_91073_ != null && ClientQuestFile.exists() && mc.f_91074_ != null) {
            if (this.observationTasks == null) {
                this.observationTasks = ClientQuestFile.INSTANCE.collect(ObservationTask.class);
            }
            if (this.observationTasks.isEmpty()) {
                return;
            }
            this.currentlyObserving = null;
            if (mc.f_91077_ != null && mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
                for (ObservationTask task : this.observationTasks) {
                    if (ClientQuestFile.INSTANCE.self.isCompleted(task) || !task.observe((Player)mc.f_91074_, mc.f_91077_) || !ClientQuestFile.INSTANCE.self.canStartTasks(task.quest)) continue;
                    this.currentlyObserving = task;
                    break;
                }
            }
            if (this.currentlyObserving != null) {
                if (!mc.m_91104_()) {
                    ++this.currentlyObservingTicks;
                }
                if (this.currentlyObservingTicks >= this.currentlyObserving.timer) {
                    new SubmitTaskMessage(this.currentlyObserving.id).sendToServer();
                    ClientQuestFile.INSTANCE.self.addProgress(this.currentlyObserving, 1L);
                    this.currentlyObserving = null;
                    this.currentlyObservingTicks = 0L;
                }
            } else {
                this.currentlyObservingTicks = 0L;
            }
        }
    }

    private void onScreenRender(PoseStack matrixStack, float tickDelta) {
        if (!ClientQuestFile.exists()) {
            return;
        }
        ClientQuestFile file = ClientQuestFile.INSTANCE;
        TeamData data = file.self;
        GlStateManager.m_84525_();
        Minecraft mc = Minecraft.m_91087_();
        int cy = mc.m_91268_().m_85446_() / 2;
        if (this.currentlyObserving != null) {
            int cx = mc.m_91268_().m_85445_() / 2;
            MutableComponent cot = this.currentlyObserving.getMutableTitle().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE});
            int sw = mc.f_91062_.m_92852_((FormattedText)cot);
            int bw = Math.max(sw, 100);
            Color4I.DARK_GRAY.withAlpha(130).draw(matrixStack, cx - bw / 2 - 3, cy - 63, bw + 6, 29);
            GuiHelper.drawHollowRect((PoseStack)matrixStack, (int)(cx - bw / 2 - 3), (int)(cy - 63), (int)(bw + 6), (int)29, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            mc.f_91062_.m_92763_(matrixStack, (Component)cot, (float)cx - (float)sw / 2.0f, (float)(cy - 60), 0xFFFFFF);
            double completed = (double)((float)this.currentlyObservingTicks + tickDelta) / (double)this.currentlyObserving.timer;
            GuiHelper.drawHollowRect((PoseStack)matrixStack, (int)(cx - bw / 2), (int)(cy - 49), (int)bw, (int)12, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            Color4I.LIGHT_BLUE.withAlpha(130).draw(matrixStack, cx - bw / 2 + 1, cy - 48, (int)(((double)bw - 2.0) * completed), 10);
            String cop = this.currentlyObservingTicks * 100L / this.currentlyObserving.timer + "%";
            mc.f_91062_.m_92750_(matrixStack, cop, (float)cx - (float)mc.f_91062_.m_92895_(cop) / 2.0f, (float)(cy - 47), 0xFFFFFF);
        }
        if (!data.pinnedQuests.isEmpty()) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            boolean first = true;
            if (data.pinnedQuests.contains(1L)) {
                for (ChapterGroup group : file.chapterGroups) {
                    for (Chapter chapter : group.chapters) {
                        for (Quest quest : chapter.quests) {
                            if (data.isCompleted(quest) || !data.canStartTasks(quest)) continue;
                            if (first) {
                                first = false;
                                continue;
                            }
                            list.add(FormattedCharSequence.f_13691_);
                        }
                    }
                }
            } else {
                LongIterator sw = data.pinnedQuests.iterator();
                while (sw.hasNext()) {
                    long q = (Long)sw.next();
                    Quest quest = file.getQuest(q);
                    if (quest == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        list.add(FormattedCharSequence.f_13691_);
                    }
                    if (data.isCompleted(quest)) {
                        TextComponent component = new TextComponent("");
                        component.m_7220_((Component)quest.getMutableTitle().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}));
                        component.m_7220_((Component)new TextComponent(" 100%").m_130940_(ChatFormatting.DARK_GREEN));
                        list.addAll(mc.f_91062_.m_92923_((FormattedText)component, 160));
                        continue;
                    }
                    list.addAll(mc.f_91062_.m_92923_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{mc.f_91062_.m_92865_().m_92389_((FormattedText)quest.getTitle(), 160, Style.f_131099_.m_131136_(Boolean.valueOf(true))), new TextComponent(" ").m_130940_(ChatFormatting.DARK_AQUA).m_130946_(data.getRelativeProgress(quest) + "%")}), 500));
                    for (Task task : quest.tasks) {
                        if (data.isCompleted(task)) continue;
                        list.addAll(mc.f_91062_.m_92923_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{mc.f_91062_.m_92865_().m_92389_((FormattedText)task.getTitle(), 160, Style.f_131099_.m_131157_(ChatFormatting.GRAY)), new TextComponent(" ").m_130940_(ChatFormatting.GREEN).m_130946_(task.formatProgress(data, data.getProgress(task))).m_130946_("/").m_130946_(task.formatMaxProgress())}), 500));
                    }
                }
            }
            if (!list.isEmpty()) {
                int mw = 0;
                for (FormattedCharSequence s : list) {
                    mw = Math.max(mw, (int)mc.f_91062_.m_92865_().m_92336_(s));
                }
                float scale = ((Double)ThemeProperties.PINNED_QUEST_SIZE.get(file)).floatValue();
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)((float)mc.m_91268_().m_85445_() - (float)mw * scale) - 8.0, (double)cy - (double)list.size() * 4.5 * (double)scale, 100.0);
                matrixStack.m_85841_(scale, scale, 1.0f);
                Color4I.BLACK.withAlpha(100).draw(matrixStack, 0, 0, mw + 8, list.size() * 9 + 8);
                for (int i = 0; i < list.size(); ++i) {
                    mc.f_91062_.m_92744_(matrixStack, (FormattedCharSequence)list.get(i), 4.0f, (float)(i * 9 + 4), -1);
                }
                matrixStack.m_85849_();
            }
        }
    }
}

